﻿/* Skript zur Demonstration von Unterabfragen in der FROM-Klausel
 * Als Benutzer SCOTT ausführen
 */
 
-- Abfrage der Durchschnittsgehälter pro Abteilung
select deptno, avg(sal) avg_sal
  from emp
 group by deptno;
 
-- Lösung des Problems mit einer INNER VIEW
select e.ename, e.job, e.sal, a.avg_sal
  from emp e
  join (select deptno, avg(sal) avg_sal
          from emp
         group by deptno) a
    on e.deptno = a.deptno
 where e.sal > a.avg_sal;
 
-- Vergleich der Lösungen Harmonisierte Unterabfrage versus Inner View
set autotrace on;

select ename, deptno, job, sal
  from emp e
 where e.sal > (select avg(a.sal)
                  from emp a
                 where a.deptno = e.deptno);
                 
select e.ename, e.job, e.sal, a.avg_sal
  from emp e
  join (select deptno, avg(sal) avg_sal
          from emp
         group by deptno) a
    on e.deptno = a.deptno
 where e.sal > a.avg_sal;
 
set autotrace off;

-- Verwendung der WITH-Klausel
with averages as 
     (select deptno, avg(sal) avg_sal
        from emp
       group by deptno)
select e.ename, e.job, e.sal, a.avg_sal
  from emp e
  join averages a on e.deptno = a.deptno
 where e.sal > a.avg_sal;
